/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.level;

import dev.compactmods.machines.client.level.RenderingLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

public class TemplateChunk
extends EmptyLevelChunk {
    private final Map<BlockPos, BlockState> blocksInChunk;
    private final Map<BlockPos, BlockEntity> tiles;
    private final Predicate<BlockPos> shouldShow;
    private final Map<BlockPos, BlockEntityTicker<BlockEntity>> tickers;

    public TemplateChunk(RenderingLevel worldIn, ChunkPos chunkPos, Map<BlockPos, StructureTemplate.StructureBlockInfo> blocksInChunk, Predicate<BlockPos> shouldShow) {
        super((Level)worldIn, chunkPos, worldIn.m_203675_(0, 0, 0));
        this.shouldShow = shouldShow;
        this.blocksInChunk = new HashMap<BlockPos, BlockState>();
        this.tiles = new HashMap<BlockPos, BlockEntity>();
        this.tickers = new HashMap<BlockPos, BlockEntityTicker<BlockEntity>>();
        for (BlockPos pos : blocksInChunk.keySet()) {
            EntityBlock eb;
            BlockEntityTicker ticker;
            BlockEntity tile;
            StructureTemplate.StructureBlockInfo blockInfo = blocksInChunk.get(pos);
            this.blocksInChunk.put(pos, blockInfo.f_74676_);
            if (blockInfo.f_74677_ == null || (tile = BlockEntity.m_155241_((BlockPos)blockInfo.f_74675_, (BlockState)blockInfo.f_74676_, (CompoundTag)blockInfo.f_74677_)) == null) continue;
            tile.m_142339_((Level)worldIn);
            tile.m_155250_(blockInfo.f_74676_);
            this.tiles.put(blockInfo.f_74675_, tile);
            tile.onLoad();
            Block block = blockInfo.f_74676_.m_60734_();
            if (!(block instanceof EntityBlock) || (ticker = (eb = (EntityBlock)block).m_142354_((Level)worldIn, blockInfo.f_74676_, tile.m_58903_())) == null) continue;
            this.tickers.put(pos, (BlockEntityTicker<BlockEntity>)ticker);
        }
    }

    public int m_141928_() {
        return super.m_141928_();
    }

    public void tick() {
        this.tickers.forEach((pos, ticker) -> ticker.m_155252_(this.m_62953_(), pos, this.m_8055_((BlockPos)pos), this.tiles.get(pos)));
    }

    @Nonnull
    public BlockState m_8055_(@Nonnull BlockPos pos) {
        BlockState state;
        if (this.shouldShow.test(pos) && (state = this.blocksInChunk.get(pos)) != null) {
            return state;
        }
        return Blocks.f_50626_.m_49966_();
    }

    @Nonnull
    public FluidState m_6425_(@Nonnull BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    @Nullable
    public BlockEntity m_5685_(@Nonnull BlockPos pos, @Nonnull LevelChunk.EntityCreationType creationMode) {
        if (!this.shouldShow.test(pos)) {
            return null;
        }
        return this.tiles.get(pos);
    }
}

